/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_10868;
import net.minecraft.class_1294;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_758;
import net.minecraft.class_9779;
import org.apache.logging.log4j.Logger;
import org.joml.Vector4f;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final class_310 MC = class_310.method_1551();
    private static final IOptifineAccessor OPTIFINE_ACCESSOR = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;
    private static class_758 mcFogRenderer = null;

    @Override
    public Vec3f getLookAtVector() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        return new Vec3f(camera.method_19335().x(), camera.method_19335().y(), camera.method_19335().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        if (MinecraftRenderWrapper.MC.field_1724 == null) {
            return false;
        }
        if (MinecraftRenderWrapper.MC.field_1724.method_6088() == null) {
            return false;
        }
        return MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_5919) != null || MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_38092) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        class_243 projectedView = camera.method_19326();
        return new Vec3d(projectedView.field_1352, projectedView.field_1351, projectedView.field_1350);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        if (mcFogRenderer == null) {
            mcFogRenderer = new class_758();
        }
        if (MinecraftRenderWrapper.MC.field_1687 == null) {
            return Color.white;
        }
        boolean isFoggy = MinecraftRenderWrapper.MC.field_1687.method_28103().method_28110(MinecraftRenderWrapper.MC.field_1773.method_19418().method_19328().method_10263(), MinecraftRenderWrapper.MC.field_1773.method_19418().method_19328().method_10260()) || MinecraftRenderWrapper.MC.field_1705.method_1740().method_1800();
        Vector4f colorValues = mcFogRenderer.method_3211(MinecraftRenderWrapper.MC.field_1773.method_19418(), MinecraftRenderWrapper.MC.field_1690.method_38521(), isFoggy, (class_9779)MinecraftRenderWrapper.MC.field_52750, MinecraftRenderWrapper.MC.field_1773.method_3195(MinecraftRenderWrapper.MC.field_52750.method_60637(true)), MinecraftRenderWrapper.MC.field_1687);
        return new Color(Math.max(0.0f, Math.min(colorValues.x, 1.0f)), Math.max(0.0f, Math.min(colorValues.y, 1.0f)), Math.max(0.0f, Math.min(colorValues.z, 1.0f)), Math.max(0.0f, Math.min(colorValues.w, 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.field_1687.method_8597().comp_642()) {
            float frameTime = MinecraftRenderWrapper.MC.field_52750.method_60636();
            int argbColorInt = MinecraftRenderWrapper.MC.field_1687.method_23777(MinecraftRenderWrapper.MC.field_1773.method_19418().method_19326(), frameTime);
            return ColorUtil.toColorObjARGB(argbColorInt);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.field_1773.method_3196(MinecraftRenderWrapper.MC.field_1773.method_19418(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.field_1690.method_38521();
    }

    @Override
    public int getScreenWidth() {
        int width = MC.method_22683().method_4489();
        if (OPTIFINE_ACCESSOR != null) {
            width = (int)((double)width * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return width;
    }

    @Override
    public int getScreenHeight() {
        int height = MC.method_22683().method_4506();
        if (OPTIFINE_ACCESSOR != null) {
            height = (int)((double)height * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return height;
    }

    protected class_276 getRenderTarget() {
        return MC.method_1522();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return false;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFrameBuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return 0;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        try {
            class_10868 glTexture = (class_10868)this.getRenderTarget().method_30278();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.method_68427();
        }
        catch (Exception e) {
            if (!this.depthTextureCastFailLogged) {
                this.depthTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target depth texture to GlTexture. MC or a rendering mod may have changed the object type.", (Throwable)e);
            }
            return 0;
        }
    }

    @Override
    public int getColorTextureId() {
        try {
            class_10868 glTexture = (class_10868)this.getRenderTarget().method_30277();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.method_68427();
        }
        catch (Exception e) {
            if (!this.colorTextureCastFailLogged) {
                this.colorTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target color texture to GlTexture. MC or a rendering mod may have changed the object type.", (Throwable)e);
            }
            return 0;
        }
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().field_1482;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().field_1481;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.field_1773.method_19418().method_19334() != class_5636.field_27888 || isBlind;
    }

    public void updateLightmap(class_1011 lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }
}

